"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineMultitenancyRoutes = defineMultitenancyRoutes;
var _multitenancy = require("./multitenancy");
var _get_tenant_info = require("./get_tenant_info");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function defineMultitenancyRoutes({
  router,
  searchGuardBackend,
  config,
  sessionStorageFactory,
  logger,
  clusterClient,
  tenantService
}) {
  (0, _multitenancy.multitenancyRoutes)({
    router,
    searchGuardBackend,
    config,
    sessionStorageFactory,
    logger,
    clusterClient,
    tenantService
  });
  (0, _get_tenant_info.getTenantInfoRoute)({
    searchGuardBackend,
    logger,
    router
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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